float	g_power;

texture	g_tex0;
sampler2D tex0 : TEXUNIT0 = sampler_state
{
	Texture = (g_tex0);
    MIPFILTER	= LINEAR;
    MAGFILTER	= LINEAR;
    MINFILTER	= LINEAR;
    AddressU	= BORDER;
    AddressV	= BORDER;
};

texture g_back;
sampler2D texBack : TEXUNIT1 = sampler_state
{
	Texture = (g_back);
    MIPFILTER	= LINEAR;
    MAGFILTER	= LINEAR;
    MINFILTER	= LINEAR;
    AddressU	= BORDER;
    AddressV	= BORDER;
};

struct vs_params
{ 
     float4 position 	: POSITION0;
     float2 tex		: TEXCOORD0;
};


//VERTEX SHADER
void vs( in vs_params IN, out vs_params OUT ) 
{
	OUT.position = IN.position;
	
	OUT.tex = IN.tex;
}

//PIXEL SHADER
float4 ps( float2 tex : TEXCOORD0 ) : COLOR
{
	float4 bg = tex2D(texBack, tex);
	float4 scr  = tex2D(tex0, tex);
	
	float4 result = bg;

 	if(scr.x)
 		result = scr;// * float4(1.0f, 0.2f, 0.2f, 1.0f);

	if(bg.a)
		result = bg;

	return result + g_power;
}

technique Default
{
    pass P0
    {
		//cullmode = none;
        VertexShader	= compile vs_3_0 vs();
        PixelShader		= compile ps_2_0 ps();
    }
}